/**
 * @file
 * Functionality to bridge Edge Animate and Drupal.
 *
 */

// Global Edge variable
// The custom object pathPrefix.libs and pathPrefix.comps should be set by Drupal
// - pathPrefix.libs: contains the path to the general lib folder
// - pathPrefix.comps: an array keyed by the edge composition id, which contains
// the project specific path
window.AdobeEdge = window.AdobeEdge || {};

/**
 * Alters the DOM for each symbol within a composition.
 *
 * Gets injected in the main _edge.js file during the composition build phase.
 * @param compId
 *   Edge composition id
 * @param symbols
 * @param fonts
 * @param resources
 * @param opts
 * @param registerCompositionDefn
 */
AdobeEdge.alterRegisterCompositionDefn = function (compId, symbols, fonts, resources, opts, registerCompositionDefn) {
  // Check if one of the know patterns for the stage id can be found.
  var stage_name = "";
  var states = "";
  // Legacy support for not-minified files.
  if (symbols.stage.states != undefined) {
    states = symbols.stage.states;
  }
  else {
    if (symbols.stage.s != undefined) {
      states = symbols.stage.s;
    }
  }

  if (states["Base State"]["${_Stage}"]) {
    stage_name = '_Stage';
  }
  else {
    // Legacy support.
    if (states["Base State"]["${_stage}"]) {
      stage_name = '_stage';
    }
  }

  if (stage_name != "") {
    // Get the original definition for the stage.
    var stage_src = states["Base State"]["${" + stage_name + "}"];
    delete states["Base State"]["${" + stage_name + "}"];

    // Inject the stage definition for all instances of a composition.
    var stages = jQuery("." + compId);
    for (var i = 0; i < stages.length; i++) {
      var stage_id = jQuery(stages[i]).attr('id');
      states["Base State"]["${_" + stage_id + "}"] = stage_src;
    }
  }

  // Alter DOMs in all symbols.
  for (var key in symbols) {
    var dom = null;
    // Legacy support for not-minified version.
    if (symbols[key].content != undefined && symbols[key].content.dom != undefined) {
      dom = symbols[key].content.dom;
    }
    // Minified version.
    else {
      if (symbols[key].cn != undefined && symbols[key].cn.dom != undefined) {
        dom = symbols[key].cn.dom;
      }
    }
    if (dom != null) {
      AdobeEdge.alterDomPaths(dom, compId);
    }
  }

  // CSS-Font support.
  var project_path = AdobeEdge.pathPrefix.comps[compId];
  for (var font_key in fonts) {
    var font = fonts[font_key];
    fonts[font_key] = font.replace(/href="([a-z0-9_-]*.css)"/g, 'href="' + project_path + '\/$1"');
  }

  // Legacy opts parameter.
  if (registerCompositionDefn.length === 4){
    registerCompositionDefn(compId, symbols, fonts, resources);
  }
  else {
    registerCompositionDefn(compId, symbols, fonts, resources, opts);
  }

}

/**
 * Alters the given DOM (e.g. preContent, dlDontent or a symbol DOM)
 *
 * All media/asset files get a project specific path prefix. The function call
 * gets directly injected into the _edgePreload.js file and will be called
 * from alterSymbols() in the main _edge.js file.
 * @param dom
 *   The edge dom
 * @param compId
 *   Edge composition id
 */
AdobeEdge.alterDomPaths = function (dom, compId) {
  // Iterate over the (flat) edge dom which contains all the assets.
  for (var key in dom) {
    // Asset files are (for now) all included through the fill property.
    var fillProp = null;

    // Not minified version.
    if (dom[key].hasOwnProperty('fill')) {
      fillProp = dom[key].fill;
    }

    // Minified version of fill.
    if (dom[key].hasOwnProperty('f')) {
      fillProp = dom[key].f;
    }

    // If the asset has one of the allowed file extensions, then add the project
    // specific prefix path (taken from the custom Drupal object in AdobeEdge).
    if (fillProp != null && fillProp.length > 1 && fillProp[1] != null && typeof fillProp[1] == 'string' && fillProp[1].match(/\.(js|png|jpg|svg|gif)$/)) {
      fillProp[1] = AdobeEdge.pathPrefix.comps[compId] + '/' + fillProp[1];
    }

    // Handle audio files.
    if (dom[key].hasOwnProperty('t') && dom[key].hasOwnProperty('sr') && dom[key].t === 'audio') {
      var audio_sources = dom[key].sr;
      for (var a = 0; a < audio_sources.length; a++) {
        if(audio_sources[a].match(/\.(mp3)$/)) {
          audio_sources[a] = AdobeEdge.pathPrefix.comps[compId] + '/' + audio_sources[a];
        }
      }
    }

    // Check nested containers which are structured as a DOM as well
    if (dom[key].hasOwnProperty('c')) {
      AdobeEdge.alterDomPaths(dom[key].c, compId);
    }
  }
};

/**
 * Alter the preloader resources.
 *
 * During the build process (edge_composition builder) the normal loadResource
 * function in the preloader.js file gets overwritten with this custom function
 * call. It allows to first alter the paths to the resource that should be
 * preloaded before the original loadResource function, which now gets called
 * after the modifications are done.
 * @param compId
 *   Edge composition id
 * @param aLoader
 *   Preloader array, which contains the objects that have to be preloaded
 * @param doDelayLoad
 *   Original doDelayLoad variable
 * @param loadResources
 *   Original loader function
 */
AdobeEdge.alterPreloadPaths = function (compId, aLoader, doDelayLoad, loadResources) {
  // Iterate over loader objects.
  for (var key in aLoader) {
    var obj = aLoader[key];
    // Check the properties of the object for JS file names.
    for (var prop in obj) {
      if (typeof(obj[prop]) == 'string') {
        if (!obj[prop].match(/^(?:https?:)?\/\//) && obj[prop].substr(obj[prop].length - 3) === ".js") {
          // If the file is a general edge library, add the lib path prefix.
          if (obj[prop].substr(0, "edge_includes/".length) === "edge_includes/") {
            // Todo: Alternative jQuery path, not in use yet.
            if (AdobeEdge.edgesuiteJqueryPathAlternative && obj[prop].match(/edge_includes\/jquery-\d(\.\d)*\.min\.js/g)) {
              obj[prop] = AdobeEdge.edgesuiteJqueryPathAlternative;
            }
            else {
              obj[prop] = AdobeEdge.pathPrefix.libs + "/" + obj[prop];
            }
          }
          // Otherwise add the project specific path prefix.
          else {
            obj[prop] = AdobeEdge.pathPrefix.comps[compId] + "/" + obj[prop];
          }
        }
      }
    }
  }

  // Check if other jQuery version exist prior to the preloader run, if
  // otherjQuery is set to true and noConflict mode is enabled then the old
  // jQuery version will be restored after the preloader has finished and
  // has passed its own jQuery version through global variable 'jQuery' to the
  // Edge runtime.

  if (typeof jQuery != 'undefined') {
    if (!AdobeEdge.otherjQuery) {
      AdobeEdge.otherjQuery = true;
      AdobeEdge.edgesuiteLogger('Other jQuery include exists: Version ' + jQuery().jquery);
    }
  }
  else {
    AdobeEdge.edgesuiteLogger('No other jQuery exists yet.');
  }

  // Call the original loader with the modified aLoader object.
  loadResources(aLoader, doDelayLoad);
}

// jQuery noConflict mode: Specific jQuery Edge Animate version.
window.jQueryEdge = window.jQueryEdge || null;

/**
 * Alter composition launch.
 *
 * This call is injected during the build process, it enables Edge Suite to
 * perform certain processing steps before a composition is being loaded. For
 * now only jQuery noConflict mode is being handled.
 */
AdobeEdge.alterOkToLaunchComposition = function (comp) {
  // Check if other jQuery version existed, if noConflict mode is enabled and
  // if it got already reverted.
  if (AdobeEdge.otherjQuery && AdobeEdge.edgesuiteNoConflict && jQueryEdge == null) {
    // Revert old 'pre' Edge jQuery version and save Edge jQuery to a separate
    // variable, which probably won't be used.
    AdobeEdge.edgesuiteLogger("Init 'edgejQuery' with: Version " + jQuery().jquery);
    jQueryEdge = jQuery.noConflict(true);
    AdobeEdge.edgesuiteLogger("Reset 'jQuery' to: Version " + jQuery().jquery);
  }

  // Fire composition launch
  AdobeEdge.okToLaunchComposition(comp);
}

/**
 * Edge Suite JavaScript Logger which gets enabled when Drupal variable
 * 'edge_suite_debug_mode' is set to true.
 *
 * @param msg
 *   Log message
 * @param level
 *   Log level
 */
AdobeEdge.edgesuiteLogger = function (msg, level) {
  if (!level) {
    level = 'Info';
  }
  if (AdobeEdge.edgesuiteDebug) {
    console.log('[ DEBUG | EdgeSuite | ' + level + ']: ' + msg);
  }
};

window.AdobeEdge=window.AdobeEdge||{};if(!AdobeEdge.yepnope){(function(a,b,c){function d(a){return"[object Function]"==o.call(a)}function e(a){return"string"==typeof a}function f(){}function g(a){return!a||"loaded"==a||"complete"==a||"uninitialized"==a}function h(){var a=p.shift();q=1,a?a.t?m(function(){("c"==a.t?B.injectCss:B.injectJs)(a.s,0,a.a,a.x,a.e,1)},0):(a(),h()):q=0}function i(a,c,d,e,f,i,j){function k(b){if(!o&&g(l.readyState)&&(u.r=o=1,!q&&h(),l.onload=l.onreadystatechange=null,b)){"img"!=a&&m(function(){t.removeChild(l)},50);for(var d in y[c])y[c].hasOwnProperty(d)&&y[c][d].onload()}}var j=j||B.errorTimeout,l=b.createElement(a),o=0,r=0,u={t:d,s:c,e:f,a:i,x:j};1===y[c]&&(r=1,y[c]=[]),"object"==a?l.data=c:(l.src=c,l.type=a),l.width=l.height="0",l.onerror=l.onload=l.onreadystatechange=function(){k.call(this,r)},p.splice(e,0,u),"img"!=a&&(r||2===y[c]?(t.insertBefore(l,s?null:n),m(k,j)):y[c].push(l))}function j(a,b,c,d,f){return q=0,b=b||"j",e(a)?i("c"==b?v:u,a,b,this.i++,c,d,f):(p.splice(this.i++,0,a),1==p.length&&h()),this}function k(){var a=B;return a.loader={load:j,i:0},a}var l=b.documentElement,m=a.setTimeout,n=b.getElementsByTagName("script")[0],o={}.toString,p=[],q=0,r="MozAppearance"in l.style,s=r&&!!b.createRange().compareNode,t=s?l:n.parentNode,l=a.opera&&"[object Opera]"==o.call(a.opera),l=!!b.attachEvent&&!l,u=r?"object":l?"script":"img",v=l?"script":u,w=Array.isArray||function(a){return"[object Array]"==o.call(a)},x=[],y={},z={timeout:function(a,b){return b.length&&(a.timeout=b[0]),a}},A,B;B=function(a){function b(a){var a=a.split("!"),b=x.length,c=a.pop(),d=a.length,c={url:c,origUrl:c,prefixes:a},e,f,g;for(f=0;f<d;f++)g=a[f].split("="),(e=z[g.shift()])&&(c=e(c,g));for(f=0;f<b;f++)c=x[f](c);return c}function g(a,e,f,g,h){var i=b(a),j=i.autoCallback;i.url.split(".").pop().split("?").shift(),i.bypass||(e&&(e=d(e)?e:e[a]||e[g]||e[a.split("/").pop().split("?")[0]]),i.instead?i.instead(a,e,f,g,h):(y[i.url]?i.noexec=!0:y[i.url]=1,f.load(i.url,i.forceCSS||!i.forceJS&&"css"==i.url.split(".").pop().split("?").shift()?"c":c,i.noexec,i.attrs,i.timeout),(d(e)||d(j))&&f.load(function(){k(),e&&e(i.origUrl,h,g),j&&j(i.origUrl,h,g),y[i.url]=2})))}function h(a,b){function c(a,c){if(a){if(e(a))c||(j=function(){var a=[].slice.call(arguments);k.apply(this,a),l()}),g(a,j,b,0,h);else if(Object(a)===a)for(n in m=function(){var b=0,c;for(c in a)a.hasOwnProperty(c)&&b++;return b}(),a)a.hasOwnProperty(n)&&(!c&&!--m&&(d(j)?j=function(){var a=[].slice.call(arguments);k.apply(this,a),l()}:j[n]=function(a){return function(){var b=[].slice.call(arguments);a&&a.apply(this,b),l()}}(k[n])),g(a[n],j,b,n,h))}else!c&&l()}var h=!!a.test,i=a.load||a.both,j=a.callback||f,k=j,l=a.complete||f,m,n;c(h?a.yep:a.nope,!!i),i&&c(i)}var i,j,l=this.yepnope.loader;if(e(a))g(a,0,l,0);else if(w(a))for(i=0;i<a.length;i++)j=a[i],e(j)?g(j,0,l,0):w(j)?B(j):Object(j)===j&&h(j,l);else Object(a)===a&&h(a,l)},B.addPrefix=function(a,b){z[a]=b},B.addFilter=function(a){x.push(a)},B.errorTimeout=1e4,null==b.readyState&&b.addEventListener&&(b.readyState="loading",b.addEventListener("DOMContentLoaded",A=function(){b.removeEventListener("DOMContentLoaded",A,0),b.readyState="complete"},0)),a.yepnope=k(),a.yepnope.executeStack=h,a.yepnope.injectJs=function(a,c,d,e,i,j){var k=b.createElement("script"),l,o,e=e||B.errorTimeout;k.src=a;for(o in d)k.setAttribute(o,d[o]);c=j?h:c||f,k.onreadystatechange=k.onload=function(){!l&&g(k.readyState)&&(l=1,c(),k.onload=k.onreadystatechange=null)},m(function(){l||(l=1,c(1))},e),i?k.onload():n.parentNode.insertBefore(k,n)},a.yepnope.injectCss=function(a,c,d,e,g,i){var e=b.createElement("link"),j,c=i?h:c||f;e.href=a,e.rel="stylesheet",e.type="text/css";for(j in d)e.setAttribute(j,d[j]);g||(n.parentNode.insertBefore(e,n),m(c,0))}})(this,document);AdobeEdge.yepnope=window.yepnope;}
(function(compId){var htFallbacks;var testEle=document.createElement("div");function isSupported(a){for(var d=testEle.style,b,g=0;g<a.length;g++)if(b=a[g],void 0!==d[b])return!0;return!1}function supportsRGBA(){testEle.cssText="background-color:rgba(150,255,150,.5)";return 0==(""+testEle.style.backgroundColor).indexOf("rgba")?!0:!1}
var hasTransform=isSupported(["transformProperty","WebkitTransform","MozTransform","OTransform","msTransform"]),hasSVG=!!document.createElementNS&&!!document.createElementNS("http://www.w3.org/2000/svg","svg").createSVGRect,hasRGBA=supportsRGBA(),hasJSON=window.JSON&&window.JSON.parse&&window.JSON.stringify,readyToPlay=!1;function safeColor(a){a=""+a;if(!hasRGBA&&0==a.indexOf("rgba")){var d=a.lastIndexOf(",");0<d&&(a="rgb("+a.substring(5,d)+")")}return a}
AdobeEdge._preloaders=AdobeEdge._preloaders||[];AdobeEdge._preloaders.push(function(){filesToLoad&&(loadResources(filesToLoad),filesToLoad=void 0)});function doLoadResources(){for(var a=0;a<AdobeEdge._preloaders.length;a++)AdobeEdge._preloaders[a]()}AdobeEdge._readyplayers=AdobeEdge._readyplayers||[];AdobeEdge._readyplayers.push(function(){readyToPlay&&AdobeEdge.alterOkToLaunchComposition(compId)});function playWhenReady(){AdobeEdge._playWhenReady=!0;for(var a=0;a<AdobeEdge._readyplayers.length;a++)AdobeEdge._readyplayers[a]()}function edgeCallback(a,d,b){htFallbacks[a]&&(a=htFallbacks[a]);AdobeEdge.preload.got[a]=!0;a==AdobeEdge.preload.last&&(!AdobeEdge.bootstrapLoading||AdobeEdge._playWhenReady?AdobeEdge.alterOkToLaunchComposition(compId):readyToPlay=!0,AdobeEdge.preload.busy=!1,0<AdobeEdge.preload.q.length&&(a=AdobeEdge.preload.q.pop(),AdobeEdge.requestResources(a.files,a.callback)))}
AdobeEdge.requestResources=AdobeEdge.requestResources||function(a,d){AdobeEdge.yepnope.errorTimeout=4E3;AdobeEdge.preload.busy=!0;AdobeEdge.preload.got=AdobeEdge.preload.got||{};var b,g=a.length,f=[],c;for(b=0;b<g;b++){c=a[b];if("string"===typeof c)0===c.indexOf("//")&&0===window.location.href.indexOf("file://")&&(c="http:"+c),url=c,c={load:url};else if(c.load&&0===c.load.indexOf("//")&&0===window.location.href.indexOf("file://")&&(c.load="http:"+c.load),url=c.yep||c.load,c.callback){var h=c.callback;c.callback=function(a,b,c){h(a,b,c)&&d(a,b,c)}}c.callback||(c.callback=d);AdobeEdge.preload.got[url]||(f.push(c),AdobeEdge.preload.last=url)}f.length&&AdobeEdge.yepnope(f)};var filesToLoad,dlContent,preContent,doDelayLoad,signaledLoading,loadingEvt,requiresSVG,htLookup={},aLoader,aEffectors,plSTF,ctrPlS,minPlW,maxPlW,plHeight,plWidth;function loadResources(a,d){AdobeEdge.preload=AdobeEdge.preload||[];AdobeEdge.preload.q=AdobeEdge.preload.q||[];d||!isCapable()?filesToLoad=a:AdobeEdge.preload.busy?AdobeEdge.preload.q.push({files:a,callback:edgeCallback}):AdobeEdge.requestResources(a,edgeCallback)}function splitUnits(a){var d={};d.num=parseFloat(a);"string"==typeof a&&(d.units=a.match(/[a-zA-Z%]+$/));d.units&&"object"==typeof d.units&&(d.units=d.units[0]);return d}
function defaultUnits(a){var d=a;"auto"!==a&&((a=splitUnits(a))&&a.units||(d+="px"));return d}function findNWC(a,d){if(-1!=String(a.className).indexOf(d))return a;for(var b=a.childNodes,g=0;g<b.length;g++){var f=findNWC(b[g],d);if(!1!=f)return f}return!1}function parent(a){return a.parentElement}function offset(a){a=a.getBoundingClientRect();return{left:a.left+window.pageXOffset,top:a.top+window.pageYOffset}}function width(a){return a.offsetWidth}function height(a){return a.offsetHeight}
function isWrapped(a){return/center-wrapper/.test(parent(a).className)}function wrapForStageScaling(a){if(!isWrapped(a)){var d=document.createElement("div"),b=document.createElement("div");d.className="flow-wrapper";b.className="center-wrapper";d.style.width="1px";d.appendChild(b);parent(a).insertBefore(d,a);b.appendChild(a)}}
function bindPSS(a,d){if(!isWrapped(a)){var b=function(){var b=isWrapped(a),f=b?parent(parent(parent(a))):parent(a),c=width(f),h=height(f),k=width(a),n=height(a),m=window.innerHeight,e=1,l=a.style;(f="body"===f.nodeName.toLowerCase())&&(h=m);c=Math.round(c);h=Math.round(h);c/=k;h/=n;"both"===d?e=Math.min(c,h):"height"===d?e=h:"width"===d&&(e=c);void 0!==maxPlW&&(e=Math.min(e,parseInt(maxPlW,10)/k));void 0!==minPlW&&(e=Math.max(e,parseInt(minPlW,10)/k));h="scale("+e+")";l.transformOrigin="0 0";l.oTransformOrigin="0 0";l.msTransformOrigin="0 0";l.webkitTransformOrigin="0 0";l.mozTransformOrigin="0 0";l.oTransformOrigin="0 0";l.transform=h;l.oTransform=h;l.msTransform=h;l.webkitTransform=h;l.mozTransform=h;l.oTransform=h;if(!f||b)parent(a).style.height=Math.round(n*e)+"px",parent(a).style.width=Math.round(k*e)+"px";b&&(b=parent(parent(a)),b.style.height=Math.round(n*e+offset(a).top-offset(b).top))};wrapForStageScaling(a);window.addEventListener("resize",function(){b()});b()}}
function centerThePreloadStage(a,d){isWrapped(a)&&(a=parent(a));var b=a.style;/^both$|^horizontal$/.test(d)&&(b.position="absolute",b.marginLeft="auto",b.marginRight="auto",b.left="0",b.right="0");/^both$|^vertical$/.test(d)&&(b.position="absolute",b.marginTop="auto",b.marginBottom="auto",b.top="0",b.bottom="0")}
function simpleContent(a,d,b){var g=document.getElementsByTagName("body")[0],f=b||findNWC(g,compId),c,h,k;f?"absolute"!=f.style.position&&"relative"!=f.style.position&&(f.style.position="relative"):f=g;plHeight&&(f.style.height=plHeight);plWidth&&(f.style.width=plWidth);/^height$|^width$|^both$/.test(plSTF)&&d&&!b&&bindPSS(f,plSTF);/^vertical$|^horizontal$|^both$/.test(ctrPlS)&&d&&!b&&centerThePreloadStage(f,ctrPlS);for(var n=0;n<a.length;n++){b=a[n];"image"===b.type?(g=document.createElement("img"),g.src=b.fill[1]):g=document.createElement("div");g.id=b.id;k=g.style;if("text"==b.type){if(c=b.font)c[0]&&""!==c[0]&&(k.fontFamily=c[0]),"object"!=typeof c[1]&&(c[1]=[c[1]]),c[1][1]||(c[1][1]="px"),c[1][0]&&""!==c[1][0]&&(k.fontSize=c[1][0]+c[1][1]),c[2]&&""!==c[2]&&(k.color=safeColor(c[2])),c[3]&&""!==c[3]&&(k.fontWeight=c[3]),c[4]&&""!==c[4]&&(k.textDecoration=b.font[4]),c[5]&&""!==c[5]&&(k.fontStyle=b.font[5]);b.align&&"auto"!=b.align&&(k.textAlign=b.align);b.position&&(k.position=b.position);(!b.rect[2]||0>=b.rect[2])&&(!b.rect[3]||0>=b.rect[3])&&(k.whiteSpace="nowrap");g.innerHTML=b.text}d&&(g.className=d);k.position="absolute";c=b.rect[0];h=b.rect[1];if(b.transform&&b.transform[0]){var m=b.transform[0][0],e=splitUnits(m);if(e&&e.units&&(m=e.num,"%"==e.units&&b.rect[2])){var e=b.rect[2],l=splitUnits(b.rect[2]);l&&l.units&&(e=l.num,"%"==l.units&&(e=e/100*f.offsetWidth));m=m/100*e;0<f.offsetWidth&&(m=m/f.offsetWidth*100)}if(e=splitUnits(c))c=e.num;c+=m;e.units||(e.units="px");c+=e.units;if(1<b.transform[0].length){m=b.transform[0][1];(e=splitUnits(m))&&e.units&&(m=e.num,"%"==e.units&&b.rect[3]&&(e=b.rect[3],(l=splitUnits(b.rect[3]))&&l.units&&(e=l.num,"%"==l.units&&(e=e/100*f.offsetHeight)),m=m/100*e,0<f.offsetHeight&&(m=m/f.offsetHeight*100)));if(e=splitUnits(h))h=e.num;h+=m;e.units||(e.units="px");h+=e.units}}k.left=defaultUnits(c);k.top=defaultUnits(h);k.width=defaultUnits(b.rect[2]);k.height=defaultUnits(b.rect[3]);b.linkURL&&(htLookup[g.id]=b,g.onclick=function(){var a=htLookup[this.id];a.linkTarget?window.open(a.linkURL,a.linkTarget):window.location.href=a.linkURL},k.cursor="pointer");f.appendChild(g);if(b.c)for(k=0;k<b.c.length;k++)simpleContent(b.c[k],d,g)}}var fnCycle=function(a){a?fnCycle&&setTimeout(fnCycle,20):a={event:"loading",progress:0};loadingEvt&&loadingEvt(a)},aBootcompsLoaded=[];window.AdobeEdge.bootstrapListeners||(window.AdobeEdge.bootstrapListeners=[]);window.AdobeEdge.bootstrapCallback=function(a){window.AdobeEdge.bootstrapListeners.push(a);if(0<aBootcompsLoaded.length)for(var d=0;d<aBootcompsLoaded.length;d++)a(aBootcompsLoaded[d])};window.AdobeEdge.preloadComplete||(window.AdobeEdge.preloadComplete={});window.AdobeEdge.preloadComplete[compId]=function(a){AdobeEdge.$_(".edgePreload"+a).css("display","none");fnCycle=null;loadingEvt&&loadingEvt({event:"done",progress:1,reason:"complete"});aBootcompsLoaded.push(a);for(var d=window.AdobeEdge.bootstrapListeners.length,b=0;b<d;b++)try{window.AdobeEdge.bootstrapListeners[b](a)}catch(g){console.log("bootstrap error "+g)}};function isCapable(){return hasTransform?requiresSVG&&!hasSVG?!1:!0:!1}
function onDocLoaded(a){window.AdobeEdge.loaded=!0;fnCycle({event:"begin"});isCapable()?(preContent&&preContent.dom&&preContent.dom.length&&simpleContent(preContent.dom,"edgePreload"+compId),filesToLoad&&!signaledLoading&&(loadResources(filesToLoad),filesToLoad=void 0)):dlContent&&dlContent.dom&&(loadingEvt&&loadingEvt({event:"done",progress:1,reason:"downlevel"}),simpleContent(dlContent.dom))};window.AdobeEdge=window.AdobeEdge||{};window.AdobeEdge.framework='jquery';if(document.addEventListener){window.addEventListener("load",onDocLoaded,false);}else if(document.attachEvent){window.attachEvent("onload",onDocLoaded);}
requiresSVG=false;doDelayLoad=false;htFallbacks={"edge_includes/jquery-2.0.3.min.js":"//ajax.googleapis.com/ajax/libs/jquery/2.0.3/jquery.min.js","edge_includes/edge.4.0.0.min.js":"//animate.adobe.com/runtime/4.0.0/edge.4.0.0.min.js"};aLoader=[{load:"//ajax.googleapis.com/ajax/libs/jquery/2.0.3/jquery.min.js",callback:function(result,key){if(!window.jQuery){yepnope({load:"edge_includes/jquery-2.0.3.min.js",callback:edgeCallback});return false;}return true;}},{load:"//animate.adobe.com/runtime/4.0.0/edge.4.0.0.min.js",callback:function(result,key){if(!window.AdobeEdge){yepnope({load:"edge_includes/edge.4.0.0.min.js",callback:edgeCallback});return false;}return true;}},{load:"anima1_7_edge.js"},{load:"anima1_7_edgeActions.js"}];if(AdobeEdge.bootstrapLoading){signaledLoading=true;AdobeEdge.loadResources=doLoadResources;AdobeEdge.playWhenReady=playWhenReady;}
AdobeEdge.alterPreloadPaths(compId, aLoader, doDelayLoad, loadResources);var plSTF="none",ctrPlS="horizontal",minPlW="0",maxPlW=undefined,plWidth="1200px",plHeight="200px";preContent={dom:[]};
//simpleContent
dlContent={dom:[]};
//simpleContent
AdobeEdge.alterDomPaths(preContent.dom, compId);
AdobeEdge.alterDomPaths(dlContent.dom, compId);
})("EDGE-65028736");;
